<?php
// Load JSON
$jsonPath = $_SERVER['DOCUMENT_ROOT'] . "/psth_of/host.json";
$jsonData = file_get_contents($jsonPath);
$data = json_decode($jsonData, true);

$currency_code_symbol = "USER_CURRENCY";

// Loop through products 1 to 100
for ($i = 1; $i <= 100; $i++) {
    $key = "product_$i";
    $product = $data[$category_wise][0]['products'][$key] ?? [];

    // Skip if no product
    if (empty($product['plan_name'])) continue;

    // Dynamically create variable like $product_3_plan_name
    ${"product_{$i}_plan_name"} = $product['plan_name'] ?? '';
    ${"product_{$i}_pid"}       = $product['pid'] ?? '';
    ${"product_{$i}_product_url"}       = $product['pid'] ?? '';
    ${"product_{$i}_description"}       = $product['description'] ?? '';

    // Pricing by currency/term
    $currencies = ['usd', 'inr', 'eur', 'jpy', 'gbp'];
    $terms = ['prefix','suffix','msetupfee','qsetupfee','ssetupfee','asetupfee','bsetupfee','tsetupfee','monthly','quarterly','semiannually','annually','biennially','triennially'];

    foreach ($currencies as $currency) {
        foreach ($terms as $term) {
            ${"product_{$i}_{$currency}_{$term}"} = $product['pricing'][strtoupper($currency)][$term] ?? '';
        }
    }
}

// Currency-based final assignment
for ($i = 1; $i <= 100; $i++) {
    if (!isset(${"product_{$i}_plan_name"})) continue;

    switch ($currency_code_symbol) {
        case "$":
            ${"product_{$i}_prefix"}  = ${"product_{$i}_usd_prefix"} ?? '';
            ${"product_{$i}_monthly"} = ${"product_{$i}_usd_monthly"} ?? '';
            ${"product_{$i}_msetupfee"} = ${"product_{$i}_usd_msetupfee"} ?? '';
            break;
        case "€":
            ${"product_{$i}_prefix"}  = ${"product_{$i}_eur_prefix"} ?? '';
            ${"product_{$i}_monthly"} = ${"product_{$i}_eur_monthly"} ?? '';
            ${"product_{$i}_msetupfee"} = ${"product_{$i}_eur_msetupfee"} ?? '';
            break;
        case "¥":
            ${"product_{$i}_prefix"}  = ${"product_{$i}_jpy_prefix"} ?? '';
            ${"product_{$i}_monthly"} = ${"product_{$i}_jpy_monthly"} ?? '';
            ${"product_{$i}_msetupfee"} = ${"product_{$i}_jpy_msetupfee"} ?? '';
            break;
        case "£":
            ${"product_{$i}_prefix"}  = ${"product_{$i}_gbp_prefix"} ?? '';
            ${"product_{$i}_monthly"} = ${"product_{$i}_gbp_monthly"} ?? '';
            ${"product_{$i}_msetupfee"} = ${"product_{$i}_gbp_msetupfee"} ?? '';
            break;
        case "₹":
            ${"product_{$i}_prefix"}  = ${"product_{$i}_inr_prefix"} ?? '';
            ${"product_{$i}_monthly"} = number_format(${"product_{$i}_inr_monthly"} ?? 0, 2);
            ${"product_{$i}_msetupfee"} = ${"product_{$i}_inr_msetupfee"} ?? '';
            break;
        default:
            ${"product_{$i}_prefix"}  = ${"product_{$i}_usd_prefix"} ?? '';
            ${"product_{$i}_monthly"} = ${"product_{$i}_usd_monthly"} ?? '';
            ${"product_{$i}_msetupfee"} = ${"product_{$i}_usd_msetupfee"} ?? '';
            break;
    }
}

//======================================
?>